/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.simibubi.create.compat.trainmap.TrainMapManager;
import com.simibubi.create.compat.trainmap.TrainMapSyncClient;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.compat.ftbchunks.LargeMapScreenAccessor;
import com.simibubi.create.foundation.mixin.compat.ftbchunks.RegionMapPanelAccessor;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.RegionMapPanel;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_768;

public class FTBChunksTrainMap {
    private static int cancelTooltips = 0;
    private static boolean renderingTooltip = false;
    private static boolean requesting;

    public static void tick() {
        if (cancelTooltips > 0) {
            --cancelTooltips;
        }
        LargeMapScreen mapScreen = FTBChunksTrainMap.getAsLargeMapScreen(class_310.method_1551().field_1755);
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue() || mapScreen == null) {
            if (requesting) {
                TrainMapSyncClient.stopRequesting();
            }
            requesting = false;
            return;
        }
        TrainMapManager.tick((class_5321<class_1937>)mapScreen.currentDimension());
        requesting = true;
        TrainMapSyncClient.requestData();
    }

    public static boolean cancelTooltips() {
        if (FTBChunksTrainMap.getAsLargeMapScreen(class_310.method_1551().field_1755) == null) {
            return false;
        }
        return !renderingTooltip && cancelTooltips != 0;
    }

    public static boolean mouseClick(class_437 screen, int mouseX, int mouseY) {
        LargeMapScreen map = FTBChunksTrainMap.getAsLargeMapScreen(screen);
        if (map == null) {
            return false;
        }
        return TrainMapManager.handleToggleWidgetClick(mouseX, mouseY, 20, 2);
    }

    public static void renderGui(class_437 screen, class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        LargeMapScreen largeMapScreen = FTBChunksTrainMap.getAsLargeMapScreen(screen);
        if (largeMapScreen == null) {
            return;
        }
        RegionMapPanel regionMapPanel = ((LargeMapScreenAccessor)largeMapScreen).getRegionPanel();
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue()) {
            FTBChunksTrainMap.renderToggleWidgetAndTooltip(mouseX, mouseY, largeMapScreen, graphics);
            return;
        }
        int blocksPerRegion = 512;
        int minX = class_3532.method_15357((double)regionMapPanel.getScrollX());
        int minY = class_3532.method_15357((double)regionMapPanel.getScrollY());
        float regionTileSize = (float)largeMapScreen.getRegionTileSize() / (float)blocksPerRegion;
        int regionMinX = ((RegionMapPanelAccessor)regionMapPanel).getRegionMinX();
        int regionMinZ = ((RegionMapPanelAccessor)regionMapPanel).getRegionMinZ();
        boolean linearFiltering = (double)largeMapScreen.getRegionTileSize() * class_310.method_1551().method_22683().method_4495() < 512.0;
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416((float)(-minX), (float)(-minY), 0.0f);
        pose.method_22905(regionTileSize, regionTileSize, 1.0f);
        pose.method_46416((float)(-regionMinX * blocksPerRegion), (float)(-regionMinZ * blocksPerRegion), 0.0f);
        mouseX += minX;
        mouseY += minY;
        mouseX = (int)((float)mouseX / regionTileSize);
        mouseY = (int)((float)mouseY / regionTileSize);
        class_768 bounds = new class_768(class_3532.method_15375((float)((float)minX / regionTileSize + (float)(regionMinX * blocksPerRegion))), class_3532.method_15375((float)((float)minY / regionTileSize + (float)(regionMinZ * blocksPerRegion))), class_3532.method_15375((float)((float)largeMapScreen.width / regionTileSize)), class_3532.method_15375((float)((float)largeMapScreen.height / regionTileSize)));
        List<class_5348> tooltip = TrainMapManager.renderAndPick(graphics, class_3532.method_15375((float)(mouseX += regionMinX * blocksPerRegion)), class_3532.method_15375((float)(mouseY += regionMinZ * blocksPerRegion)), partialTicks, linearFiltering, bounds);
        pose.method_22909();
        if (!FTBChunksTrainMap.renderToggleWidgetAndTooltip(mouseX, mouseY, largeMapScreen, graphics) && tooltip != null) {
            renderingTooltip = true;
            RemovedGuiUtils.drawHoveringText(graphics, tooltip, mouseX, mouseY, largeMapScreen.width, largeMapScreen.height, 256, class_310.method_1551().field_1772);
            renderingTooltip = false;
            cancelTooltips = 5;
        }
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 300.0f);
        for (Widget widget : largeMapScreen.getWidgets()) {
            if (!widget.isEnabled() || widget == regionMapPanel) continue;
            widget.draw(graphics, largeMapScreen.getTheme(), widget.getPosX(), widget.getPosY(), widget.getWidth(), widget.getHeight());
        }
        pose.method_22909();
    }

    private static boolean renderToggleWidgetAndTooltip(int mouseX, int mouseY, LargeMapScreen largeMapScreen, class_332 graphics) {
        TrainMapManager.renderToggleWidget(graphics, 20, 2);
        if (!TrainMapManager.isToggleWidgetHovered(mouseX, mouseY, 20, 2)) {
            return false;
        }
        renderingTooltip = true;
        RemovedGuiUtils.drawHoveringText(graphics, List.of(CreateLang.translate("train_map.toggle", new Object[0]).component()), mouseX, mouseY + 20, largeMapScreen.width, largeMapScreen.height, 256, class_310.method_1551().field_1772);
        renderingTooltip = false;
        cancelTooltips = 5;
        return true;
    }

    private static LargeMapScreen getAsLargeMapScreen(class_437 screen) {
        if (!(screen instanceof ScreenWrapper)) {
            return null;
        }
        ScreenWrapper screenWrapper = (ScreenWrapper)screen;
        BaseScreen wrapped = screenWrapper.getGui();
        if (!(wrapped instanceof LargeMapScreen)) {
            return null;
        }
        LargeMapScreen largeMapScreen = (LargeMapScreen)wrapped;
        return largeMapScreen;
    }
}

